﻿using System;
using System.Dynamic;

public class CustomDynamic : DynamicObject
{
    private static DateTime FirstSighting = new DateTime(1947, 3, 13);

    public override bool TryGetMember(GetMemberBinder binder,
                                      out object result)
    {
        var compare = binder.IgnoreCase ?
            StringComparer.InvariantCultureIgnoreCase :
            StringComparer.InvariantCulture;
        if (compare.Compare(binder.Name, "Brigadoon") == 0)
        {
            // Wioska Brigadoon słynie z tego, że pojawia się tylko raz na sto lat.
            DateTime today = DateTime.Now.Date;
            if (today.DayOfYear == FirstSighting.DayOfYear)
            {
                // Odpowiedni dzień. Co z rokiem?
                int yearsSinceFirstSighting = today.Year - FirstSighting.Year;
                if (yearsSinceFirstSighting % 100 == 0)
                {
                    result = "Witamy w Brigadoon. Zachowaj ostrożność na drodze.";
                    return true;
                }
            }
        }
        return base.TryGetMember(binder, out result);
    }
}